/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.relocations.com.mongodb.internal.operation;

import net.impactdev.impactor.relocations.com.mongodb.MongoException;
import net.impactdev.impactor.relocations.com.mongodb.MongoWriteConcernException;
import net.impactdev.impactor.relocations.com.mongodb.ServerAddress;
import net.impactdev.impactor.relocations.com.mongodb.WriteConcern;
import net.impactdev.impactor.relocations.com.mongodb.WriteConcernResult;
import net.impactdev.impactor.relocations.com.mongodb.bulk.WriteConcernError;
import net.impactdev.impactor.relocations.com.mongodb.connection.ConnectionDescription;
import net.impactdev.impactor.relocations.com.mongodb.internal.connection.ProtocolHelper;
import net.impactdev.impactor.relocations.com.mongodb.internal.operation.ServerVersionHelper;
import net.impactdev.impactor.relocations.org.bson.BsonDocument;
import net.impactdev.impactor.relocations.org.bson.BsonString;

public final class WriteConcernHelper {
    public static void appendWriteConcernToCommand(WriteConcern writeConcern, BsonDocument commandDocument, ConnectionDescription description) {
        if (writeConcern != null && !writeConcern.isServerDefault() && ServerVersionHelper.serverIsAtLeastVersionThreeDotFour(description)) {
            commandDocument.put("writeConcern", writeConcern.asDocument());
        }
    }

    public static void throwOnWriteConcernError(BsonDocument result, ServerAddress serverAddress) {
        if (WriteConcernHelper.hasWriteConcernError(result)) {
            WriteConcernHelper.throwOnSpecialException(result, serverAddress);
            throw WriteConcernHelper.createWriteConcernException(result, serverAddress);
        }
    }

    public static void throwOnSpecialException(BsonDocument result, ServerAddress serverAddress) {
        MongoException specialException = ProtocolHelper.createSpecialException(result, serverAddress, "errmsg");
        if (specialException != null) {
            throw specialException;
        }
    }

    public static boolean hasWriteConcernError(BsonDocument result) {
        return result.containsKey("writeConcernError");
    }

    public static MongoWriteConcernException createWriteConcernException(BsonDocument result, ServerAddress serverAddress) {
        return new MongoWriteConcernException(WriteConcernHelper.createWriteConcernError(result.getDocument("writeConcernError")), WriteConcernResult.acknowledged(0, false, null), serverAddress);
    }

    public static WriteConcernError createWriteConcernError(BsonDocument writeConcernErrorDocument) {
        return new WriteConcernError(writeConcernErrorDocument.getNumber("code").intValue(), writeConcernErrorDocument.getString("codeName", new BsonString("")).getValue(), writeConcernErrorDocument.getString("errmsg").getValue(), writeConcernErrorDocument.getDocument("errInfo", new BsonDocument()));
    }

    private WriteConcernHelper() {
    }
}

